$(document).ready(function(){
    $('.formForHandler').on('submit', function(event){
        event.preventDefault(); // Zamezí standardnímu odeslání formuláře

        let form = $(this);
        let formName = form.attr('name');
        let messageId = '#' + formName + '-message';
        let formData = form.serialize() + '&formName=' + formName;

        $.ajax({
            url: './process-form.php',
            type: 'post',
            data: formData,
            success: function(response){
                console.log(response);
                $(messageId).html(response);
                if (form.hasClass('clearOnSubmit')) {
                    form[0].reset(); // Resetuje formulář, pokud má formulář požadovanou třídu.
                }
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log('Došlo k chybě: ' + textStatus);
                $(messageId).html('Došlo k chybě při odesílání formuláře.');
            }
        });
    });
});
