<?php

class CouchDBConnector {

    private $url = "http://localhost:5984";
    private $login = "admin";
    private $password = "password";

    private function setupCurl($database, $method) {
        $ch = curl_init();

        // Nastavení cURL pro request
        curl_setopt($ch, CURLOPT_URL, "$this->url/$database");
        curl_setopt($ch, $method, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_USERPWD, "$this->login:$this->password");

        return $ch;
    }

    public function insert($database, $data) {
        $ch = $this->setupCurl($database, CURLOPT_POST);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            return false;
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return $http_code == 201;
    }
}