<?php

class CouchDBConnector {

    private $url = "http://localhost:5984";
    private $login = "admin";
    private $password = "password";

    private function setupCurl($database, $method = CURLOPT_HTTPGET, $afterlink = "") {
        $ch = curl_init();

        // Nastavení cURL pro request
        curl_setopt($ch, CURLOPT_URL, empty($afterlink) ? "$this->url/$database" : "$this->url/$database/$afterlink");
        curl_setopt($ch, $method, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_USERPWD, "$this->login:$this->password");

        return $ch;
    }

    public function insert($database, $data) {
        $ch = $this->setupCurl($database, CURLOPT_POST);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            return false;
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return $http_code == 201;
    }

    public function getUserByUsernameAndPassword($username, $password, $database, $design_id, $view) {
        $afterlink = $design_id . "/" . "_view" . "/" . $view . "?key=" . urlencode('"' . $username . '"');
        $ch = $this->setupCurl($database, CURLOPT_HTTPGET, $afterlink);

        $response = curl_exec($ch);
        curl_close($ch);

        if ($response) {
            $data = json_decode($response, true);
            if (isset($data['rows']) && count($data['rows']) > 0) {
                $row = $data['rows'][0];
                if (isset($row['value'])) {
                    if (password_verify($password, $row['value']['password'])) {
                        return $row['value']["username"];
                    }
                }
            }
        }

        return null;
    }
}